//
//  FleetManager.h
//  FlightPad
//
//  Created by Claus Richter on 2/9/19.
//

#import <UIKit/UIKit.h>

#import <StoreKit/StoreKit.h>


#import "VDTextFieldWithFixedDropDown.h"

@interface FleetManager : UIViewController<
SKProductsRequestDelegate,SKPaymentTransactionObserver> 
{
    
    //***************************************************************************
    //IAP
    SKProductsRequest *productsRequest;
    
    NSArray *validProducts;
    
    int maxAvailableCategory, flagNeedToLoadAircraft, flagFleetWasChanged, checkHighestCategory, alertTransferValue, triggerCheckForACupdates;
    NSMutableArray *arrayHighestCategory;
    
    NSString *selectedProductID;
    
    SKProduct *validProduct;
    SKProduct *validProductTEst;
    
    NSMutableArray *uploadedAircraft;
    
    NSMutableArray *arrayValidProductIDs;
    
    NSMutableArray *arrayDictAllAircraft;
    
    NSString *stringACtoUpdate;
    
    NSMutableArray *arrayLoadedAircraft;
  
    NSMutableDictionary *myFleetNewDict;
    
    NSMutableArray *arrayReplaceMyFleetID;
    NSMutableArray *arrayReplaceMyFleetIDVersion;
    
    //***************************************************************************
    
    
    NSMutableArray *arrayAllCallsigns;    
    NSMutableArray *arrayMyFleet;
    
    float conversionFactorWeight, conversionFactorMoment;
    int triggerUseArmLong, triggerUseArmLat, flagReduceNumberOfAircraft, flagFilterAircraftSetupList, flagRestoreDone, flagAddAircraftAsTrial, flagShowOnlyFleetIncrease;
   
    
    float gyronimoCredits;
    float alertFlag, alertTransfer;
    
    float numberOfStandardAircraftInMyFleet;
    
     NSMutableArray *availableACTypes;
    
    NSMutableArray *checkArrayForCounting;
    
   
}


@property (weak, nonatomic) IBOutlet VDTextFieldWithFixedDropDown *dropDownFilterAircraftOnSetup;

@property (weak, nonatomic) IBOutlet VDTextFieldWithFixedDropDown *dropDownFilterAircraftAllAvailable;

- (IBAction)dropDown1DidEndOnExit:(id)sender;
- (IBAction)dropDown2DidEndOnExit:(id)sender;

//***************************************************************************
//IAP
- (IBAction)restoreCompletedTransactions:(id)sender;

- (void)fetchAvailableProducts;

- (BOOL)canMakePurchases;

- (void)purchaseMyProduct:(SKProduct*)product;



@property (weak, nonatomic) IBOutlet UILabel *labelLoadingOptions;

@property (strong, nonatomic) IBOutlet UIView *viewLoadingIAPs;

@property (strong, nonatomic) IBOutlet UIActivityIndicatorView *activityIndicator;


//***************************************************************************





- (void) createAllAvailableAircraftList;

- (void) createAircraftSetupList;



@property (strong, nonatomic) IBOutlet UIScrollView *scrollViewAllAvailableAircraft;
@property (strong, nonatomic) IBOutlet UIView *viewAllAvailableAircraft;
@property (strong, nonatomic) IBOutlet UIView *viewMyFleet;

- (IBAction)actionLoadAircraftData:(id)sender;
@property (strong, nonatomic) IBOutlet UIButton *buttonLoadAircraftData;




@property (strong, nonatomic) IBOutlet UIView *viewAllAvailList;

@property (strong, nonatomic) IBOutlet UIScrollView *scrollViewForViewMyFleet;



@property (strong, nonatomic) IBOutlet UIView *viewOne;

// AC Setup

@property (strong, nonatomic) IBOutlet UIView *viewAircraftSetup;

@property (strong, nonatomic) IBOutlet UIScrollView *scrollViewAircraftSetup;

@property (strong, nonatomic) IBOutlet UIView *viewAircraftSetupList;

- (IBAction)actionStartFlightPad:(id)sender;
@property (strong, nonatomic) IBOutlet UIButton *buttonStartFlightPad;



- (IBAction)actionViewAllAvailList:(id)sender;

- (IBAction)actionViewInAppPurchases:(id)sender;

@property (strong, nonatomic) IBOutlet UIView *viewInAppPurchases;


@property (strong, nonatomic) IBOutlet UIScrollView *scrollViewIAPlist;


- (IBAction)actionCloseInAppPurchase:(id)sender;

@property (strong, nonatomic) IBOutlet UIView *viewIAPlist;


@property (strong, nonatomic) IBOutlet UILabel *labelAvailableCategory;

@property (strong, nonatomic) IBOutlet UILabel *labelDownloadSIze;


@property (strong, nonatomic) IBOutlet UILabel *lcallsign;
@property (strong, nonatomic) IBOutlet UITextField *tfCallsign;
@property (strong, nonatomic) IBOutlet UILabel *lManufact;
@property (strong, nonatomic) IBOutlet UILabel *tfManufact;

@property (strong, nonatomic) IBOutlet UILabel *lOrigUNits;
@property (strong, nonatomic) IBOutlet UILabel *tfOrigun;
@property (strong, nonatomic) IBOutlet UILabel *lUnits;
@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentOrigUnits;

@property (strong, nonatomic) IBOutlet UIView *lImage;
@property (strong, nonatomic) IBOutlet UILabel *lBew;
@property (strong, nonatomic) IBOutlet UITextField *tfBEW;
@property (strong, nonatomic) IBOutlet UILabel *lArm;

@property (strong, nonatomic) IBOutlet UITextField *tfArm;

@property (strong, nonatomic) IBOutlet UILabel *lMoment;
@property (strong, nonatomic) IBOutlet UITextField *tfMometn;
@property (strong, nonatomic) IBOutlet UILabel *lArmlat;
@property (strong, nonatomic) IBOutlet UITextField *tfArmLat;
@property (strong, nonatomic) IBOutlet UILabel *lMomLat;
@property (strong, nonatomic) IBOutlet UITextField *tfMomlat;
@property (strong, nonatomic) IBOutlet UILabel *lLongitu;

@property (strong, nonatomic) IBOutlet UILabel *lLateral;

@property (strong, nonatomic) IBOutlet UILabel *lPurchaseAberDalli;
@property (strong, nonatomic) IBOutlet UILabel *lEnterUnitsAberRichtig;
@property (strong, nonatomic) IBOutlet UIButton *butUpgrade;
@property (strong, nonatomic) IBOutlet UIButton *butCreateAFLight;

@property (strong, nonatomic) IBOutlet UIButton *butCopy;
@property (strong, nonatomic) IBOutlet UIButton *butDelete;


@property (strong, nonatomic) IBOutlet UIView *lLineView;


- (IBAction)actionCheckForAircraftDataUpdates:(id)sender;

- (IBAction)actionForceReloadAircraftData:(id)sender;

@property (strong, nonatomic) IBOutlet UIButton *buttonForceReload;


- (IBAction)actionLoadFleet:(id)sender;

@property (strong, nonatomic) IBOutlet UIButton *buttonUpdateFleetControlACdata;



@property (strong, nonatomic) IBOutlet UILabel *labelMyAircraftFleet;

- (IBAction)actionOpenPrivacyPolicy:(id)sender;

- (IBAction)actionOpenTermsOfUse:(id)sender;

- (IBAction)actionIncreaseFleet:(id)sender;
@property (strong, nonatomic) IBOutlet UIButton *buttonIncreaseFleet;


@property (strong, nonatomic) IBOutlet UIButton *buttonDone;


@end

